<?php
/**
 * Settings Page - System configuration
 */

$tab = $_GET['tab'] ?? 'general';

// Handle POST updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $action === 'update') {
    $pdo->prepare("UPDATE settings SET site_title = ?, theme = ? WHERE id = 1")
         ->execute([$_POST['site_title'], $_POST['theme']]);
    redirect('?page=settings', 'Settings updated');
}

echo "<h1>Settings</h1>";

// Tab navigation
echo "<div style='border-bottom:1px solid var(--border); margin-bottom:20px;'>";
echo "<div style='display:flex; gap:20px;'>";
echo "<a href='?page=settings&tab=general' style='padding:10px 0; border-bottom:3px solid " . ($tab === 'general' ? 'var(--accent)' : 'transparent') . "; text-decoration:none; color:var(--text-primary);'>General</a>";
echo "<a href='?page=settings&tab=departments' style='padding:10px 0; border-bottom:3px solid " . ($tab === 'departments' ? 'var(--accent)' : 'transparent') . "; text-decoration:none; color:var(--text-primary);'>Departments</a>";
echo "<a href='?page=settings&tab=templates' style='padding:10px 0; border-bottom:3px solid " . ($tab === 'templates' ? 'var(--accent)' : 'transparent') . "; text-decoration:none; color:var(--text-primary);'>Templates</a>";
echo "<a href='?page=settings&tab=employers' style='padding:10px 0; border-bottom:3px solid " . ($tab === 'employers' ? 'var(--accent)' : 'transparent') . "; text-decoration:none; color:var(--text-primary);'>Employer Contacts</a>";
echo "</div></div>";

if ($tab === 'general') {
    echo "<div class='card'>";
    echo "<h2>General Settings</h2>";
    echo "<form method='post' action='?page=settings&action=update'>";
    
    echo "<div class='form-group'>";
    echo "<label>Site Title</label>";
    echo "<input type='text' name='site_title' value='" . esc($settings['site_title']) . "' required>";
    echo "</div>";
    
    echo "<div class='form-group'>";
    echo "<label>Theme</label>";
    echo "<select name='theme'>";
    echo "<option value='dark'" . ($settings['theme'] === 'dark' ? ' selected' : '') . ">Dark</option>";
    echo "<option value='light'" . ($settings['theme'] === 'light' ? ' selected' : '') . ">Light</option>";
    echo "</select>";
    echo "</div>";
    
    echo "<button type='submit' class='btn btn-primary'>Save Settings</button>";
    echo "</form>";
    echo "</div>";
}

elseif ($tab === 'departments') {
    $departments = $pdo->query("SELECT * FROM departments ORDER BY name")->fetchAll();
    
    echo "<div class='card'>";
    echo "<h2>Departments</h2>";
    echo "<p class='mb-20'>Manage organizational departments for worker assignment.</p>";
    
    echo "<table>";
    echo "<thead><tr><th>Name</th><th>ECN Code</th><th>Status</th><th>Workers</th></tr></thead>";
    echo "<tbody>";
    
    foreach ($departments as $d) {
        $workerCount = $pdo->prepare("SELECT COUNT(*) FROM people WHERE department_id = ? AND status = 'active'");
        $workerCount->execute([$d['id']]);
        $count = $workerCount->fetchColumn();
        
        echo "<tr>";
        echo "<td><strong>" . esc($d['name']) . "</strong></td>";
        echo "<td>" . esc($d['ecn']) . "</td>";
        echo "<td><span class='badge badge-" . ($d['is_active'] ? 'success' : 'error') . "'>" . ($d['is_active'] ? 'Active' : 'Inactive') . "</span></td>";
        echo "<td>$count</td>";
        echo "</tr>";
    }
    
    echo "</tbody></table>";
    echo "</div>";
}

elseif ($tab === 'templates') {
    $templates = $pdo->query("SELECT * FROM templates ORDER BY name")->fetchAll();
    
    echo "<div class='card'>";
    echo "<h2>Import Templates</h2>";
    echo "<p class='mb-20'>Templates define how CSV files are mapped to dose records.</p>";
    
    if (empty($templates)) {
        echo "<p>No templates configured yet.</p>";
    } else {
        echo "<table>";
        echo "<thead><tr><th>Name</th><th>Provider</th><th>Titles in First Row</th><th>Created</th></tr></thead>";
        echo "<tbody>";
        
        foreach ($templates as $t) {
            echo "<tr>";
            echo "<td><strong>" . esc($t['name']) . "</strong></td>";
            echo "<td>" . esc($t['provider']) . "</td>";
            echo "<td>" . ($t['titles_in_first_row'] ? 'Yes' : 'No') . "</td>";
            echo "<td>" . date('d/m/Y', strtotime($t['created_at'])) . "</td>";
            echo "</tr>";
        }
        
        echo "</tbody></table>";
    }
    echo "</div>";
}

elseif ($tab === 'employers') {
    $employers = $pdo->query("SELECT * FROM employer_contacts ORDER BY employer_name")->fetchAll();
    
    echo "<div class='card'>";
    echo "<h2>External Employer Contacts</h2>";
    echo "<p class='mb-20'>Manage external organizations for multi-employer dose tracking.</p>";
    
    if (empty($employers)) {
        echo "<p>No external employers configured yet.</p>";
    } else {
        echo "<table>";
        echo "<thead><tr><th>Employer</th><th>Contact</th><th>RPS</th><th>Email</th><th>Workers</th></tr></thead>";
        echo "<tbody>";
        
        foreach ($employers as $emp) {
            $workerCount = $pdo->prepare("SELECT COUNT(DISTINCT p.id) FROM people p WHERE (p.employer_2_id = ? OR p.employer_3_id = ?) AND p.status = 'active'");
            $workerCount->execute([$emp['id'], $emp['id']]);
            $count = $workerCount->fetchColumn();
            
            echo "<tr>";
            echo "<td><strong>" . esc($emp['employer_name']) . "</strong></td>";
            echo "<td>" . esc($emp['contact_name']) . "</td>";
            echo "<td>" . esc($emp['rps_name']) . "</td>";
            echo "<td>" . esc($emp['contact_email']) . "</td>";
            echo "<td>$count</td>";
            echo "</tr>";
        }
        
        echo "</tbody></table>";
    }
    echo "</div>";
}
