<?php
/**
 * Reports Page - Various system reports
 */

echo "<h1>Reports</h1>";

echo "<div class='grid grid-2'>";

// Department Report
echo "<div class='card'>";
echo "<h2>Department Reports</h2>";
echo "<p style='color:var(--text-secondary); margin:10px 0;'>View dose trends and statistics by department.</p>";
echo "<a href='?page=reports&action=department' class='btn btn-primary'>Generate Report</a>";
echo "</div>";

// Triggers Report
echo "<div class='card'>";
echo "<h2>Triggers Exceeded</h2>";
echo "<p style='color:var(--text-secondary); margin:10px 0;'>Workers who exceeded dose limits.</p>";
$currentYear = date('Y');
$exceeded = $pdo->query("SELECT COUNT(DISTINCT p.id) FROM people p 
                        JOIN doses d ON d.person_id = p.id 
                        JOIN triggers t ON t.department_id = p.department_id AND t.quantity = d.quantity
                        WHERE YEAR(d.start_date) = $currentYear 
                        GROUP BY p.id, d.quantity 
                        HAVING SUM(d.value_mSv) > MAX(t.ytd_mSv)")->fetchColumn();
echo "<p><strong>Workers exceeding limits:</strong> " . ($exceeded ?: 0) . "</p>";
echo "<a href='?page=reports&action=triggers' class='btn btn-primary'>View Report</a>";
echo "</div>";

// Returns Report
echo "<div class='card'>";
echo "<h2>Returns Report</h2>";
echo "<p style='color:var(--text-secondary); margin:10px 0;'>Badge return rates by department.</p>";
echo "<a href='?page=reports&action=returns' class='btn btn-primary'>Generate Report</a>";
echo "</div>";

// Dose Sharing
echo "<div class='card'>";
echo "<h2>Dose Sharing</h2>";
echo "<p style='color:var(--text-secondary); margin:10px 0;'>Generate reports for external employers.</p>";
echo "<a href='?page=dose_sharing' class='btn btn-primary'>Dose Sharing Reports</a>";
echo "</div>";

echo "</div>";

// Quick stats
$stats = [
    'total_doses' => $pdo->query("SELECT COUNT(*) FROM doses")->fetchColumn(),
    'this_year' => $pdo->query("SELECT COUNT(*) FROM doses WHERE YEAR(start_date) = YEAR(CURDATE())")->fetchColumn(),
    'this_month' => $pdo->query("SELECT COUNT(*) FROM doses WHERE YEAR(start_date) = YEAR(CURDATE()) AND MONTH(start_date) = MONTH(CURDATE())")->fetchColumn()
];

echo "<div class='card'>";
echo "<h2>Quick Statistics</h2>";
echo "<div class='grid grid-3'>";
echo "<div class='stat-card'><div class='stat-value'>{$stats['total_doses']}</div><div class='stat-label'>Total Doses</div></div>";
echo "<div class='stat-card'><div class='stat-value'>{$stats['this_year']}</div><div class='stat-label'>This Year</div></div>";
echo "<div class='stat-card'><div class='stat-value'>{$stats['this_month']}</div><div class='stat-label'>This Month</div></div>";
echo "</div></div>";
