<?php
/**
 * Profile Page - Individual person with dose history
 */

$id = $_GET['id'] ?? 0;

$stmt = $pdo->prepare("SELECT p.*, d.name as dept_name, 
                      e2.employer_name as emp2_name, e3.employer_name as emp3_name
                      FROM people p 
                      JOIN departments d ON p.department_id = d.id
                      LEFT JOIN employer_contacts e2 ON p.employer_2_id = e2.id
                      LEFT JOIN employer_contacts e3 ON p.employer_3_id = e3.id
                      WHERE p.id = ?");
$stmt->execute([$id]);
$person = $stmt->fetch();

if (!$person) {
    redirect('?page=people', 'Person not found', 'error');
}

// Get doses
$doses = $pdo->prepare("SELECT d.*, u.username as added_by_name FROM doses d 
                       LEFT JOIN users u ON d.created_by = u.id 
                       WHERE d.person_id = ? ORDER BY d.start_date DESC");
$doses->execute([$id]);
$doses = $doses->fetchAll();

// Get notes
$notes = $pdo->prepare("SELECT n.*, u.username FROM notes n 
                       JOIN users u ON n.author_id = u.id 
                       WHERE n.person_id = ? ORDER BY n.created_at DESC");
$notes->execute([$id]);
$notes = $notes->fetchAll();

echo "<h1>" . esc($person['forename'] . ' ' . $person['surname']) . "</h1>";

// Person details
echo "<div class='card'>";
echo "<h2>Personal Information</h2>";
echo "<div class='grid grid-3'>";
echo "<div><strong>Department:</strong><br>" . esc($person['dept_name']) . "</div>";
echo "<div><strong>ECN:</strong><br>" . (esc($person['ecn']) ?: '-') . "</div>";
echo "<div><strong>Status:</strong><br><span class='badge badge-" . ($person['status'] === 'active' ? 'success' : 'error') . "'>" . esc(ucfirst($person['status'])) . "</span></div>";

if ($person['started_at']) {
    echo "<div><strong>Started:</strong><br>" . date('d/m/Y', strtotime($person['started_at'])) . "</div>";
}
if ($person['left_at']) {
    echo "<div><strong>Left:</strong><br>" . date('d/m/Y', strtotime($person['left_at'])) . "</div>";
}
echo "</div></div>";

// Multi-employer info
if ($person['emp2_name'] || $person['emp3_name']) {
    echo "<div class='card' style='border-left:3px solid var(--warning)'>";
    echo "<h2>⚠ Multi-Employer Worker</h2>";
    echo "<div class='grid grid-3'>";
    
    if ($person['emp2_name']) {
        echo "<div><strong>External Employer 2:</strong><br>" . esc($person['emp2_name']);
        if ($person['last_dose_employer_2']) {
            $days = floor((time() - strtotime($person['last_dose_employer_2'])) / 86400);
            echo "<br><small>Last dose: " . date('d/m/Y', strtotime($person['last_dose_employer_2'])) . " ($days days ago)</small>";
        }
        echo "</div>";
    }
    
    if ($person['emp3_name']) {
        echo "<div><strong>External Employer 3:</strong><br>" . esc($person['emp3_name']);
        if ($person['last_dose_employer_3']) {
            $days = floor((time() - strtotime($person['last_dose_employer_3'])) / 86400);
            echo "<br><small>Last dose: " . date('d/m/Y', strtotime($person['last_dose_employer_3'])) . " ($days days ago)</small>";
        }
        echo "</div>";
    }
    
    echo "</div></div>";
}

// Dose history
echo "<div class='card'>";
echo "<h2>Dose History</h2>";

if (empty($doses)) {
    echo "<p>No dose records yet</p>";
} else {
    echo "<div style='overflow-x:auto;'><table>";
    echo "<thead><tr><th>Period</th><th>Quantity</th><th>Body Part</th><th>Value (mSv)</th><th>Employer</th><th>Source</th></tr></thead>";
    echo "<tbody>";
    
    foreach ($doses as $d) {
        echo "<tr>";
        echo "<td>" . date('d/m/Y', strtotime($d['start_date'])) . " → " . date('d/m/Y', strtotime($d['end_date'])) . "</td>";
        echo "<td>" . esc($d['quantity']) . "</td>";
        echo "<td>" . esc($d['bodypart_label']) . "</td>";
        echo "<td>" . number_format($d['value_mSv'], 4) . "</td>";
        echo "<td>" . esc($d['employer']) . "</td>";
        echo "<td><span class='badge badge-info'>" . esc(ucfirst($d['source'])) . "</span></td>";
        echo "</tr>";
    }
    
    echo "</tbody></table></div>";
}
echo "</div>";

// Notes
echo "<div class='card'>";
echo "<h2>Notes</h2>";

if (empty($notes)) {
    echo "<p>No notes yet</p>";
} else {
    foreach ($notes as $n) {
        echo "<div style='border-left:3px solid var(--accent); padding-left:15px; margin-bottom:15px;'>";
        echo "<div style='color:var(--text-secondary); font-size:13px; margin-bottom:5px;'>" . esc($n['username']) . " • " . date('d/m/Y H:i', strtotime($n['created_at'])) . "</div>";
        echo "<div>" . nl2br(esc($n['text'])) . "</div>";
        echo "</div>";
    }
}
echo "</div>";
