<?php
/**
 * People Management Page
 */

// Handle termination
if ($action === 'terminate' && in_array($_SESSION['role'], ['admin', 'editor'])) {
    $id = $_GET['id'] ?? 0;
    $pdo->beginTransaction();
    $pdo->prepare("UPDATE people SET status = 'terminated', terminated_by = ?, terminated_at = NOW(), left_at = CURDATE() WHERE id = ?")->execute([$_SESSION['user_id'], $id]);
    $pdo->prepare("INSERT INTO notes (person_id, author_id, text) VALUES (?, ?, ?)")->execute([$id, $_SESSION['user_id'], "Terminated by {$_SESSION['username']}"]);
    audit($pdo, 'terminate', 'people', $id, []);
    $pdo->commit();
    redirect('?page=people', 'Person terminated');
}

// Handle reinstatement
elseif ($action === 'reinstate' && in_array($_SESSION['role'], ['admin', 'editor'])) {
    $id = $_GET['id'] ?? 0;
    $pdo->beginTransaction();
    $pdo->prepare("UPDATE people SET status = 'active', terminated_by = NULL, terminated_at = NULL, left_at = NULL WHERE id = ?")->execute([$id]);
    $pdo->prepare("INSERT INTO notes (person_id, author_id, text) VALUES (?, ?, ?)")->execute([$id, $_SESSION['user_id'], "Reinstated by {$_SESSION['username']}"]);
    audit($pdo, 'reinstate', 'people', $id, []);
    $pdo->commit();
    redirect('?page=people', 'Person reinstated');
}

// List people
$search = $_GET['search'] ?? '';
$dept_filter = $_GET['dept'] ?? '';
$status_filter = $_GET['status'] ?? 'active';

$sql = "SELECT p.*, d.name as dept_name FROM people p LEFT JOIN departments d ON p.department_id = d.id WHERE 1=1";
$params = [];

if ($search) {
    $sql .= " AND (CONCAT(p.forename, ' ', p.surname) LIKE ? OR p.ecn LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}
if ($dept_filter) {
    $sql .= " AND p.department_id = ?";
    $params[] = $dept_filter;
}
if ($status_filter) {
    $sql .= " AND p.status = ?";
    $params[] = $status_filter;
}

$sql .= " ORDER BY p.surname, p.forename";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$people = $stmt->fetchAll();

$departments = $pdo->query("SELECT * FROM departments WHERE is_active = 1 ORDER BY name")->fetchAll();

echo "<h1>People Management</h1>";

// Search filters
echo "<div class='card'>";
echo "<form method='get' class='grid grid-3'>";
echo "<input type='hidden' name='page' value='people'>";
echo "<div class='form-group' style='margin:0'><label>Search</label><input type='text' name='search' placeholder='Name or ECN' value='" . esc($search) . "'></div>";
echo "<div class='form-group' style='margin:0'><label>Department</label><select name='dept'><option value=''>All</option>";
foreach ($departments as $d) echo "<option value='{$d['id']}'" . ($dept_filter == $d['id'] ? ' selected' : '') . ">" . esc($d['name']) . "</option>";
echo "</select></div>";
echo "<div class='form-group' style='margin:0'><label>Status</label><select name='status'><option value=''>All</option><option value='active'" . ($status_filter === 'active' ? ' selected' : '') . ">Active</option><option value='terminated'" . ($status_filter === 'terminated' ? ' selected' : '') . ">Terminated</option></select></div>";
echo "<button type='submit' class='btn btn-primary' style='align-self:end;'>Filter</button>";
echo "</form></div>";

// People list
echo "<div class='card'>";
echo "<div class='flex-between mb-20'><h2>Workers (" . count($people) . ")</h2></div>";

if (empty($people)) {
    echo "<p>No people found</p>";
} else {
    echo "<div style='overflow-x:auto;'><table>";
    echo "<thead><tr><th>Name</th><th>ECN</th><th>Department</th><th>Status</th><th>Multi-Employer</th><th>Actions</th></tr></thead>";
    echo "<tbody>";
    
    foreach ($people as $p) {
        $multiEmployer = (!empty($p['employer_2_id']) || !empty($p['employer_3_id']));
        echo "<tr>";
        echo "<td><strong>" . esc($p['forename'] . ' ' . $p['surname']) . "</strong></td>";
        echo "<td>" . esc($p['ecn']) . "</td>";
        echo "<td>" . esc($p['dept_name']) . "</td>";
        echo "<td><span class='badge badge-" . ($p['status'] === 'active' ? 'success' : 'error') . "'>" . esc(ucfirst($p['status'])) . "</span></td>";
        echo "<td>" . ($multiEmployer ? "<span class='badge badge-warning'>⚠ Yes</span>" : "-") . "</td>";
        echo "<td>";
        echo "<a href='?page=profile&id=" . $p['id'] . "' class='btn btn-secondary btn-sm'>View</a> ";
        
        if (in_array($_SESSION['role'], ['admin', 'editor'])) {
            if ($p['status'] === 'active') {
                echo "<a href='?page=people&action=terminate&id=" . $p['id'] . "' class='btn btn-error btn-sm' onclick='return confirm(\"Terminate?\")'>Terminate</a>";
            } else {
                echo "<a href='?page=people&action=reinstate&id=" . $p['id'] . "' class='btn btn-success btn-sm' onclick='return confirm(\"Reinstate?\")'>Reinstate</a>";
            }
        }
        echo "</td></tr>";
    }
    
    echo "</tbody></table></div>";
}
echo "</div>";
