<?php
/**
 * Dose Sharing Page - Generate reports for external employers
 */

$employers = $pdo->query("SELECT * FROM employer_contacts WHERE is_active = 1 ORDER BY employer_name")->fetchAll();
$departments = $pdo->query("SELECT * FROM departments WHERE is_active = 1 ORDER BY name")->fetchAll();

echo "<h1>Dose Sharing Reports</h1>";

echo "<div class='card'>";
echo "<h2>Generate Report</h2>";
echo "<p style='color:var(--text-secondary); margin-bottom:20px;'>";
echo "Create a professional dose sharing report for workers who are employed by both your organization and an external employer.";
echo "</p>";

if (empty($employers)) {
    echo "<div class='alert alert-warning'>";
    echo "⚠️ No external employer contacts found. Please add employer contacts in Settings first.";
    echo "</div>";
} else {
    echo "<form method='get' action='print_dose_report.php' target='_blank'>";
    
    echo "<div class='grid grid-2'>";
    
    echo "<div class='form-group'>";
    echo "<label>External Employer *</label>";
    echo "<select name='employer_id' required>";
    echo "<option value=''>Select employer...</option>";
    foreach ($employers as $emp) {
        $personCount = $pdo->prepare("SELECT COUNT(DISTINCT p.id) FROM people p 
                                      WHERE (p.employer_2_id = ? OR p.employer_3_id = ?) 
                                      AND p.status = 'active'");
        $personCount->execute([$emp['id'], $emp['id']]);
        $count = $personCount->fetchColumn();
        
        echo "<option value='{$emp['id']}'>" . esc($emp['employer_name']) . " ($count workers)</option>";
    }
    echo "</select>";
    echo "</div>";
    
    echo "<div class='form-group'>";
    echo "<label>Department (Optional)</label>";
    echo "<select name='department'>";
    echo "<option value=''>All Departments</option>";
    foreach ($departments as $d) {
        echo "<option value='{$d['id']}'>" . esc($d['name']) . "</option>";
    }
    echo "</select>";
    echo "</div>";
    
    echo "</div>";
    
    echo "<div class='grid grid-2'>";
    
    echo "<div class='form-group'>";
    echo "<label>Start Date *</label>";
    echo "<input type='date' name='start_date' value='" . date('Y-m-d', strtotime('-12 months')) . "' required>";
    echo "</div>";
    
    echo "<div class='form-group'>";
    echo "<label>End Date *</label>";
    echo "<input type='date' name='end_date' value='" . date('Y-m-d') . "' required>";
    echo "</div>";
    
    echo "</div>";
    
    echo "<button type='submit' class='btn btn-primary'>Generate Report</button>";
    echo "</form>";
}

echo "</div>";

// Show summary of shared workers
echo "<div class='card'>";
echo "<h2>Shared Workers Summary</h2>";

if (empty($employers)) {
    echo "<p>No external employers configured yet.</p>";
} else {
    echo "<table>";
    echo "<thead><tr>";
    echo "<th>External Employer</th>";
    echo "<th>Contact</th>";
    echo "<th>Shared Workers</th>";
    echo "<th>Last Report</th>";
    echo "</tr></thead>";
    echo "<tbody>";
    
    foreach ($employers as $emp) {
        // Count shared workers
        $stmt = $pdo->prepare("SELECT COUNT(DISTINCT p.id) FROM people p 
                              WHERE (p.employer_2_id = ? OR p.employer_3_id = ?) 
                              AND p.status = 'active'");
        $stmt->execute([$emp['id'], $emp['id']]);
        $workerCount = $stmt->fetchColumn();
        
        // Get last report date
        $stmt = $pdo->prepare("SELECT MAX(created_at) FROM dose_sharing_log 
                              WHERE employer_name = ?");
        $stmt->execute([$emp['employer_name']]);
        $lastReport = $stmt->fetchColumn();
        
        echo "<tr>";
        echo "<td><strong>" . esc($emp['employer_name']) . "</strong>";
        if ($emp['contact_email']) {
            echo "<br><small style='color:var(--text-secondary)'>" . esc($emp['contact_email']) . "</small>";
        }
        echo "</td>";
        echo "<td>" . esc($emp['contact_name'] ?: '-') . "</td>";
        echo "<td><span class='badge badge-info'>" . $workerCount . " workers</span></td>";
        echo "<td>" . ($lastReport ? date('d/m/Y', strtotime($lastReport)) : 'Never') . "</td>";
        echo "</tr>";
    }
    
    echo "</tbody></table>";
}

echo "</div>";

// Recent dose sharing activity
$recentLogs = $pdo->query("SELECT dsl.*, u.username FROM dose_sharing_log dsl 
                          LEFT JOIN users u ON dsl.sent_by = u.id 
                          ORDER BY dsl.created_at DESC LIMIT 10")->fetchAll();

if (!empty($recentLogs)) {
    echo "<div class='card'>";
    echo "<h2>Recent Dose Sharing Activity</h2>";
    echo "<table>";
    echo "<thead><tr>";
    echo "<th>Date</th>";
    echo "<th>Employer</th>";
    echo "<th>Action</th>";
    echo "<th>User</th>";
    echo "</tr></thead>";
    echo "<tbody>";
    
    foreach ($recentLogs as $log) {
        echo "<tr>";
        echo "<td>" . date('d/m/Y H:i', strtotime($log['created_at'])) . "</td>";
        echo "<td>" . esc($log['employer_name']) . "</td>";
        echo "<td>" . esc($log['action_type']) . "</td>";
        echo "<td>" . esc($log['username']) . "</td>";
        echo "</tr>";
    }
    
    echo "</tbody></table>";
    echo "</div>";
}
