<?php
/**
 * Dashboard Page - System overview with KPIs and charts
 */

// Get KPIs
$kpis = [
    'active_workers' => $pdo->query("SELECT COUNT(*) FROM people WHERE status = 'active'")->fetchColumn(),
    'dose_records' => $pdo->query("SELECT COUNT(*) FROM doses")->fetchColumn(),
    'imports' => $pdo->query("SELECT COUNT(*) FROM imports")->fetchColumn(),
    'pending_merges' => $pdo->query("SELECT COUNT(*) FROM import_rows WHERE status IN ('needs_merge', 'needs_employer_assignment')")->fetchColumn(),
    'multi_employer' => $pdo->query("SELECT COUNT(*) FROM people WHERE (employer_2_id IS NOT NULL OR employer_3_id IS NOT NULL) AND status = 'active'")->fetchColumn()
];

echo "<h1>Dashboard</h1>";

// KPI Cards
echo "<div class='grid grid-4'>";
echo "<div class='card stat-card'><div class='stat-value'>{$kpis['active_workers']}</div><div class='stat-label'>Active Workers</div></div>";
echo "<div class='card stat-card'><div class='stat-value'>{$kpis['dose_records']}</div><div class='stat-label'>Dose Records</div></div>";
echo "<div class='card stat-card'><div class='stat-value'>{$kpis['multi_employer']}</div><div class='stat-label'>Multi-Employer Workers</div></div>";
echo "<div class='card stat-card'><div class='stat-value' style='color:var(--warning)'>{$kpis['pending_merges']}</div><div class='stat-label'>Pending Reviews</div></div>";
echo "</div>";

// Quick Actions
echo "<div class='card'>";
echo "<h2>Quick Actions</h2>";
echo "<div class='flex flex-gap'>";
if (in_array($_SESSION['role'], ['admin', 'editor'])) {
    echo "<a href='?page=import' class='btn btn-primary'>Import Data</a>";
    if ($kpis['pending_merges'] > 0) {
        echo "<a href='?page=merges' class='btn btn-warning'>Review Merge Queue ({$kpis['pending_merges']})</a>";
    }
}
echo "<a href='?page=reports' class='btn btn-secondary'>View Reports</a>";
echo "<a href='?page=people' class='btn btn-secondary'>Manage People</a>";
echo "</div></div>";

// Recent Activity
$recentImports = $pdo->query("SELECT i.*, u.username FROM imports i LEFT JOIN users u ON i.created_by = u.id ORDER BY i.created_at DESC LIMIT 5")->fetchAll();

if (!empty($recentImports)) {
    echo "<div class='card'>";
    echo "<h2>Recent Imports</h2>";
    echo "<table>";
    echo "<thead><tr><th>Filename</th><th>Rows</th><th>Imported By</th><th>Date</th></tr></thead>";
    echo "<tbody>";
    foreach ($recentImports as $imp) {
        echo "<tr>";
        echo "<td>" . esc($imp['filename']) . "</td>";
        echo "<td>" . $imp['row_count'] . "</td>";
        echo "<td>" . esc($imp['username']) . "</td>";
        echo "<td>" . date('d/m/Y H:i', strtotime($imp['created_at'])) . "</td>";
        echo "</tr>";
    }
    echo "</tbody></table>";
    echo "</div>";
}
