<?php
/**
 * Audit Log Page - System activity tracking
 */

$limit = 50;
$page_num = isset($_GET['p']) ? (int)$_GET['p'] : 1;
$offset = ($page_num - 1) * $limit;

$stmt = $pdo->prepare("SELECT a.*, u.username FROM audit a 
                      LEFT JOIN users u ON a.user_id = u.id 
                      ORDER BY a.created_at DESC LIMIT ? OFFSET ?");
$stmt->bindValue(1, $limit, PDO::PARAM_INT);
$stmt->bindValue(2, $offset, PDO::PARAM_INT);
$stmt->execute();
$auditLog = $stmt->fetchAll();

$totalRecords = $pdo->query("SELECT COUNT(*) FROM audit")->fetchColumn();
$totalPages = ceil($totalRecords / $limit);

echo "<h1>Audit Log</h1>";

echo "<div class='card'>";
echo "<div class='flex-between mb-20'>";
echo "<h2>System Activity</h2>";
echo "<p><strong>Total Records:</strong> " . number_format($totalRecords) . "</p>";
echo "</div>";

if (empty($auditLog)) {
    echo "<p>No audit records yet</p>";
} else {
    echo "<div style='overflow-x:auto;'>";
    echo "<table>";
    echo "<thead><tr><th>User</th><th>Action</th><th>Entity</th><th>ID</th><th>Timestamp</th><th>Details</th></tr></thead>";
    echo "<tbody>";
    
    foreach ($auditLog as $entry) {
        echo "<tr>";
        echo "<td>" . esc($entry['username'] ?? 'System') . "</td>";
        echo "<td><span class='badge badge-info'>" . esc($entry['action']) . "</span></td>";
        echo "<td>" . esc($entry['entity']) . "</td>";
        echo "<td>" . $entry['entity_id'] . "</td>";
        echo "<td>" . date('d/m/Y H:i:s', strtotime($entry['created_at'])) . "</td>";
        echo "<td>";
        
        $payload = json_decode($entry['payload'], true);
        if ($payload && !empty($payload)) {
            echo "<details style='cursor:pointer;'>";
            echo "<summary style='color:var(--accent);'>View</summary>";
            echo "<pre style='font-size:11px; margin-top:5px; background:var(--bg-card); padding:10px; border-radius:3px;'>";
            echo esc(json_encode($payload, JSON_PRETTY_PRINT));
            echo "</pre></details>";
        } else {
            echo "-";
        }
        
        echo "</td>";
        echo "</tr>";
    }
    
    echo "</tbody></table>";
    echo "</div>";
    
    // Pagination
    if ($totalPages > 1) {
        echo "<div style='margin-top:20px; display:flex; gap:10px; justify-content:center; align-items:center;'>";
        
        if ($page_num > 1) {
            echo "<a href='?page=audit&p=" . ($page_num - 1) . "' class='btn btn-secondary'>← Previous</a>";
        }
        
        echo "<span>Page " . $page_num . " of " . $totalPages . "</span>";
        
        if ($page_num < $totalPages) {
            echo "<a href='?page=audit&p=" . ($page_num + 1) . "' class='btn btn-secondary'>Next →</a>";
        }
        
        echo "</div>";
    }
}

echo "</div>";
