# PDMS - Personal Dosimetry Management System
## Complete Installation & Setup Guide

### 📦 What's Included

This is a complete rebuild of the PDMS from scratch with all features properly integrated and working. The package includes:

- **install.php** - 3-step auto-installer with visual progress
- **index.php** - Main application with modular page routing
- **config.php** - Auto-generated configuration file
- **modules.php** - Module system for extensibility
- **print_dose_report.php** - Standalone dose sharing reports
- **Complete page system** - All features in separate organized files
- **Professional CSS** - Dark/light theme with responsive design
- **Client-side JS** - Interactive features and validations

### 🚀 Installation Instructions

#### Step 1: Upload Files

Upload all files to your web server. Your directory structure should look like:

```
/your-pdms-folder/
├── install.php
├── index.php
├── modules.php
├── print_dose_report.php
├── assets/
│   ├── style.css
│   └── script.js
├── pages/
│   ├── dashboard.php
│   ├── people.php
│   ├── profile.php
│   ├── import.php
│   ├── merges.php
│   ├── reports.php
│   ├── dose_sharing.php
│   ├── settings.php
│   └── audit.php
└── views/
    └── login.php
```

#### Step 2: Set Permissions

Ensure the web server can write to the directory:
```bash
chmod 755 /your-pdms-folder
chmod 644 *.php
```

#### Step 3: Run Installer

1. Navigate to: `http://your-domain.com/your-pdms-folder/install.php`
2. Follow the 3-step wizard:
   - **Step 1**: Enter database credentials
   - **Step 2**: Create admin account
   - **Step 3**: Finalize installation

#### Step 4: Login

After installation, you'll be redirected to the login page. Use the admin credentials you created during setup.

### 📋 System Requirements

- **PHP**: 7.4 or higher
- **MySQL**: 5.7 or higher (or MariaDB 10.2+)
- **Extensions**: PDO, PDO_MySQL
- **Web Server**: Apache, Nginx, or similar
- **Browser**: Modern browser with JavaScript enabled

### 🎯 Key Features

#### 1. **People Management**
- Track healthcare workers across multiple departments
- Multi-employer support (workers can have up to 3 employers)
- Person profiles with complete dose history
- Status tracking (active/terminated)

#### 2. **Dose Tracking**
- Comprehensive dose recording (Hp10, Hp007, Hp3)
- Multiple body part tracking
- Source attribution (internal/external employers)
- Automatic trigger detection for safety limits

#### 3. **Import System**
- CSV/TSV file imports with template system
- Automatic person matching
- Intelligent external employer detection
- Merge queue for ambiguous matches
- **External employer assignment workflow**

#### 4. **Multi-Employer Features**
- External employer contact management
- Dose sharing reports between employers
- Last dose tracking per employer
- Employer assignment from import queue

#### 5. **Reports**
- Department reports with visualizations
- Period reports with trigger flags
- Returns tracking reports
- Triggers exceeded reports
- **Dose sharing reports** for external employers

#### 6. **Module System**
- Extensible architecture
- Custom modules without core modifications
- Role-based access control
- Menu integration

#### 7. **Security & Audit**
- Role-based permissions (admin/editor/viewer)
- Session management with timeouts
- Complete audit trail
- Password hashing

### 🔧 Configuration

After installation, configure the system via Settings (Admin only):

1. **General Settings**
   - Site title and branding
   - Theme (dark/light)
   - Employer list
   - ECN list

2. **Departments**
   - Add/edit departments
   - Assign ECN codes
   - Set active/inactive status

3. **Body Parts**
   - Configure available body parts per quantity type
   - Customize tracking labels

4. **Triggers**
   - Set monthly and YTD dose limits
   - Per department and quantity type

5. **Import Templates**
   - Define CSV column mappings
   - Unit conversion rules
   - Body part mappings

6. **Employer Contacts**
   - External employer details
   - Contact information for dose sharing

### 📊 Typical Workflow

#### Importing Dose Data

1. Go to **Import** page
2. Select appropriate template
3. Upload CSV/TSV file
4. **Preview** imported data
5. **Commit** import
6. Review **Merge Queue** for any flagged records
7. Assign external employers if needed

#### External Employer Assignment

When an import detects a dose from an external employer:

1. Record appears in **Merge Queue** with status "needs_employer_assignment"
2. System shows matched person and external employer
3. Admin selects which employer slot (2 or 3) to assign
4. System creates/links employer contact
5. Dose is imported and linked correctly

#### Generating Dose Sharing Reports

1. Go to **Dose Sharing** page
2. Select external employer
3. Choose date range
4. Optionally filter by department
5. **Generate Report** (professional PDF format)
6. Report shows all shared workers with doses
7. Print or save as PDF for transmission

### 🔐 Default Setup

After installation, the system includes:

- **1 Admin User**: As configured during install
- **1 Department**: "General" (can be renamed)
- **1 Import Template**: Standard template (can be customized)
- **Default Body Parts**: Configurable in Settings
- **Default Triggers**: 20 mSv monthly and YTD (adjustable)

### 🐛 Troubleshooting

#### Installation Issues

**Problem**: "Database connection failed"
**Solution**: Check database credentials in install form. Ensure MySQL server is running.

**Problem**: "Cannot create config.php"
**Solution**: Check file permissions on the directory (should be writable by web server).

#### Import Issues

**Problem**: "No import templates found"
**Solution**: Go to Settings → Templates and create at least one import template.

**Problem**: "Too many records in merge queue"
**Solution**: This is normal for first imports. Review merge queue and accept/create matches.

**Problem**: "External employer not assigned"
**Solution**: Go to Merge Queue, find flagged records, and assign employer using the workflow.

#### Performance Issues

**Problem**: "Slow page loads"
**Solution**: 
- Enable MySQL query caching
- Add indexes to large tables
- Increase PHP memory limit

**Problem**: "Import timeouts"
**Solution**: 
- Import files in smaller batches
- Increase PHP max_execution_time
- Check server resources

### 📝 Data Structure

#### Key Tables

- **people**: Healthcare workers being monitored
- **doses**: Individual dose records
- **employer_contacts**: External employer information
- **departments**: Organizational departments
- **imports**: Import tracking
- **import_rows**: Merge queue for ambiguous records
- **triggers**: Dose limit thresholds
- **audit**: Complete system audit trail

### 🔄 Upgrading

This is a clean v2.0 rebuild. To upgrade from v1.x:

1. **Backup** your existing database
2. Install v2.0 in a new directory
3. Point to your existing database during installation
4. System will auto-migrate existing tables
5. Test thoroughly before switching over

### 🆘 Support

For issues or questions:

1. Check this guide first
2. Review the audit log for system errors
3. Check PHP error logs
4. Ensure all requirements are met

### 📈 Best Practices

1. **Regular Backups**: Database and uploads directory
2. **User Training**: Especially on merge queue workflow
3. **Template Testing**: Test import templates with small files first
4. **Employer Contacts**: Keep external employer information updated
5. **Audit Review**: Regularly review audit log for unusual activity

### 🎓 Key Concepts

**Multi-Employer**: Workers can work for up to 3 employers simultaneously. The primary employer is tracked via department, secondary and tertiary via employer_2_id and employer_3_id.

**Merge Queue**: Import records that cannot be auto-matched are flagged for manual review. This prevents duplicate person records and ensures data integrity.

**External Employer Assignment**: When a dose comes from an external employer not yet assigned to the worker, it's flagged for admin review and assignment.

**Dose Sharing**: Formal reports generated for external employers showing doses their shared workers received at your organization.

**Triggers**: Safety thresholds that flag workers who exceed dose limits, enabling proactive safety management.

### ✅ Post-Installation Checklist

- [ ] Admin login successful
- [ ] General settings configured
- [ ] At least one department created
- [ ] Body parts configured
- [ ] Triggers set appropriately
- [ ] Import template created and tested
- [ ] Sample import completed successfully
- [ ] Merge queue reviewed
- [ ] External employer contact added
- [ ] Dose sharing report generated
- [ ] User accounts created for staff
- [ ] Backup procedure established

---

**Version**: 2.0 Complete Rebuild
**Date**: 2025
**Status**: Production Ready
